/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator.dialog;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.regex.Pattern;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.engine.ByteFlags;
import lib.toma.animations.engine.screen.animator.AnimationProject;
import lib.toma.animations.engine.screen.animator.Animator;
import lib.toma.animations.engine.screen.animator.AnimatorScreen;
import lib.toma.animations.engine.screen.animator.dialog.DialogScreen;
import lib.toma.animations.engine.screen.animator.widget.LabelWidget;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class NewProjectDialog
extends DialogScreen {
    private final Pattern namePattern = Pattern.compile("[a-z][a-z0-9_]*");
    private final Pattern cyclePattern = Pattern.compile("[1-9][0-9]{0,2}");
    private TextFieldWidget nameField;
    private TextFieldWidget cycleField;
    private CheckboxButton onRepeat;
    private ByteFlags errorFlags = new ByteFlags();

    public NewProjectDialog(AnimatorScreen animator) {
        super((ITextComponent)new TranslationTextComponent("screen.animator.dialog.new_project"), animator);
        this.setDimensions(155, 145);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new LabelWidget(this.left() + 5, this.top() + 15, 50, 15, (ITextComponent)new StringTextComponent("Project name"), this.field_230712_o_));
        this.nameField = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.left() + 5, this.top() + 30, this.dWidth() - 10, 20, StringTextComponent.field_240750_d_));
        this.nameField.func_212954_a(this::nameField_changed);
        this.nameField.func_146180_a("animation_" + LocalTime.now().format(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT)).replaceAll(":", ""));
        this.func_230480_a_(new LabelWidget(this.left() + 5, this.top() + 55, 50, 15, (ITextComponent)new StringTextComponent("Initial animation cycle [ticks]"), this.field_230712_o_));
        this.cycleField = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.left() + 5, this.top() + 70, this.dWidth() - 10, 20, StringTextComponent.field_240750_d_));
        this.cycleField.func_212954_a(this::cycleField_changed);
        this.cycleField.func_146180_a("50");
        this.onRepeat = (CheckboxButton)this.func_230480_a_((Widget)new CheckboxButton(this.left() + 5, this.top() + 95, this.dWidth() - 10, 20, (ITextComponent)new StringTextComponent("On repeat"), false));
        int btnWidthP = this.dWidth() - 10;
        int btnWidth = (btnWidthP - 5) / 2;
        this.cancel = (Button)this.func_230480_a_((Widget)new Button(this.left() + 5, this.top() + 120, btnWidth, 20, (ITextComponent)new StringTextComponent("Cancel"), this::cancel_clicked));
        this.confirm = (Button)this.func_230480_a_((Widget)new Button(this.left() + 10 + btnWidth, this.top() + 120, btnWidth, 20, (ITextComponent)new StringTextComponent("Confirm"), this::confirm_clicked));
        this.updateConfirmButtonState();
    }

    private void nameField_changed(String text) {
        if (this.namePattern.matcher(text).matches()) {
            this.nameField.func_146193_g(0xE0E0E0);
            this.setErrorFlags(0, false);
        } else {
            this.nameField.func_146193_g(0xE00000);
            this.setErrorFlags(0, true);
        }
    }

    private void cycleField_changed(String text) {
        if (this.cyclePattern.matcher(text).matches()) {
            this.cycleField.func_146193_g(0xE0E0E0);
            this.setErrorFlags(1, false);
        } else {
            this.cycleField.func_146193_g(0xE00000);
            this.setErrorFlags(1, true);
        }
    }

    private void setErrorFlags(int offset, boolean value) {
        if (value) {
            this.errorFlags.set(offset);
        } else {
            this.errorFlags.clear(offset);
        }
        this.updateConfirmButtonState();
    }

    private void confirm_clicked(Button button) {
        Animator animator = Animator.get();
        AnimationProject lastProject = animator.getProject();
        if (!lastProject.isSaved()) {
            ConfirmScreen warning = new ConfirmScreen(proceed -> this.handleUnsavedProject(proceed, this::createNewProject), (ITextComponent)new StringTextComponent("Warning"), (ITextComponent)new StringTextComponent("Your project is not saved. Do you wish to proceed anyway?"));
            warning.func_146350_a(25);
            this.field_230706_i_.func_147108_a((Screen)warning);
        } else {
            this.createNewProject();
        }
    }

    private void handleUnsavedProject(boolean proceed, Runnable event) {
        if (proceed) {
            event.run();
        } else {
            this.field_230706_i_.func_147108_a((Screen)this);
        }
    }

    private void createNewProject() {
        String name = this.nameField.func_146179_b();
        int value = NewProjectDialog.parse(this.cycleField.func_146179_b(), 50);
        boolean repeat = this.onRepeat.func_212942_a();
        AnimationProject project = new AnimationProject(name, value);
        project.getAnimationControl().setOnRepeat(repeat);
        Animator.get().setUsingProject(project);
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        pipeline.insert(Animator.ANIMATOR_TYPE);
        this.getParent().clearBackgroundAnimation();
        this.showParent();
    }

    private void updateConfirmButtonState() {
        if (this.confirm != null) {
            this.confirm.field_230693_o_ = this.errorFlags.isEmpty();
        }
    }
}

